import pygame

class GameContext :
    def __init__(
        self,
        dt, events, keys,
        screen,
    ):
        self.dt = dt
        self.events = events
        self.keys = keys
        self.screen = screen

class MyCube :
    def __init__(
        self,
        x = 0, y = 0,
        w = 100, h = 100,
        speed=100,
        fill_color=(255, 255, 255)
    ):
        self.x = x
        self.y = y
        self.w = w
        self.h = h
        self.speed = speed
        self.fill_color = fill_color
    def update(self, ctx):
        dt = ctx.dt
        speed = self.speed
        if ctx.keys[pygame.K_a] :
            self.x -= dt * speed
        if ctx.keys[pygame.K_d] :
            self.x += dt * speed
        if ctx.keys[pygame.K_w] :
            self.y -= dt * speed
        if ctx.keys[pygame.K_s] :
            self.y += dt * speed
    def draw(self, ctx):
        pygame.draw.rect(
            ctx.screen, self.fill_color,
            (self.x, self.y,
             self.w, self.h),
        )

import random
cubes = []
for i in range(2000) :
    cube = MyCube(
        speed=random.randint(10, 250),
        fill_color=(
            random.randint(0, 255),
            random.randint(0, 255),
            random.randint(0, 255),
        ),
        x=random.randint(0, 300),
        y = random.randint(0, 400),
    )
    cubes.append(cube)
clock = pygame.time.Clock()
screen = pygame.display.set_mode((640, 480))
bg_color = (0, 0, 0)
fps = 30
running = True
while running :
    dt = clock.tick(fps) / 1000.0
    events = pygame.event.get()
    for event in events :
        if event.type == pygame.QUIT :
            running = False
    keys = pygame.key.get_pressed()
    ctx = GameContext(dt, events, keys, screen)
    screen.fill(bg_color)
    for cube in cubes :
        cube.update(ctx)
        cube.draw(ctx)

    pygame.display.update()
pygame.quit()

