import game
import pygame
import random

# Объект платформы
class PlayerRect(game.Rect):
    # ---------------
    def __init__(self, up_key, down_key, vd=(0, 1), speed=200, **kwargs):
        super().__init__(**kwargs)
        self.speed = speed
        self.up_key = up_key
        self.down_key = down_key
        # --------------
        self.vd = vd
    def update(self, ctx): # Поведение плафтормы за кадр
        dt = ctx.dt
        speed = self.speed
        if ctx.keys[self.up_key] :
            if self.x > 0 :
                self.x -= dt * speed * self.vd[0]
            if self.y > 0 :
                self.y -= dt * speed * self.vd[1]
        if ctx.keys[self.down_key] :
            if (self.x + self.w) < ctx.game.resolution[0] :
                self.x += dt * speed * self.vd[0]
            if (self.y + self.h) < ctx.game.resolution[1] :
                self.y += dt * speed * self.vd[1]

# Сам шар летающий
class BallRect(game.Rect):
    # ------- dd
    def __init__(self, dx=50, dy=50, dd=40, **kwargs):
        super().__init__(**kwargs)
        self.dx = dx
        self.dy = dy
        self.dd = dd
    def update(self, ctx):
        res = ctx.game.resolution
        dt = ctx.dt
        self.x += self.dx * dt
        self.y += self.dy * dt
        # Отталкивание от игроков
        if (self.intersects_with(player_left) or
                self.intersects_with(player_right) ):
            self.dx *= -1
            self.dy += random.randint(0, self.dd) - self.dd/2
        if (self.intersects_with(player_top) or
                self.intersects_with(player_bottom)) :
            self.dy *= -1
            self.dx += random.randint(0, self.dd) - self.dd/2

        # Касание стен (проигрыш)
        if self.x <= 0 or self.y <= 0:
            counter.score -= 1
            self.x, self.y = res[0]/2, res[1]/2
        elif self.x+self.w >= res[0] or (self.y + self.h) >= res[1]:
            counter.score += 1
            self.x, self.y = res[0]/2, res[1]/2            

class Counter(game.Text):
    def __init__(self, **kwargs):
        self.score = 0
        super().__init__(str(self.score), **kwargs)

    def update(self, ctx):
        if self.score == 0 :
            self.fill_color = (255, 255, 255)
            self.text = str(self.score)
        elif self.score > 0 :
            self.fill_color = (255, 0, 0)
            self.text = str(self.score)
        else:
            self.fill_color = (0, 0, 255)
            self.text = str(-self.score)


g = game.Game()
player_width = 30
player_left = PlayerRect(pygame.K_w, pygame.K_s,
                     fill_color=(255, 0, 0), w=player_width)
player_right = PlayerRect(
    pygame.K_UP, pygame.K_DOWN,
    fill_color=(0, 0, 255), w=player_width)
player_right.x = g.resolution[0] - player_right.w

player_top = PlayerRect(
    pygame.K_a, pygame.K_d,
    fill_color=player_left.fill_color, h=player_width,
    vd=(1, 0))

player_bottom = PlayerRect(
    pygame.K_LEFT, pygame.K_RIGHT,
    fill_color=player_right.fill_color, h=player_width,
    vd=(1, 0))
player_bottom.y = g.resolution[1] - player_bottom.h
player_bottom.x = g.resolution[0] - player_bottom.w
ball_size = 30
ball_speed = 150
ball = BallRect(w=ball_size, h=ball_size, dx=ball_speed, dy=ball_speed)
ball.x = g.resolution[0] / 2 - 100
ball.y = g.resolution[1] / 2 - 100
counter = Counter(x=320, y=240)
g.objects = [player_left, player_right,
             player_top, player_bottom, ball,
             counter]
g.run()

