import game as game
import pygame

class PlayerRect(game.Rect):
    def __init__(self, speed=200, **kwargs):
        super().__init__(**kwargs)
        self.speed = speed
    def update(self, ctx):
        dt = ctx.dt
        speed = self.speed
        if ctx.keys[pygame.K_a] :
            self.x -= dt * speed
        if ctx.keys[pygame.K_d] :
            self.x += dt * speed
        if ctx.keys[pygame.K_w] :
            self.y -= dt * speed
        if ctx.keys[pygame.K_s] :
            self.y += dt * speed

import random
rects = []
for i in range(2000) :
    rect = PlayerRect(
        speed=random.randint(10, 250),
        fill_color=(
            random.randint(0, 255),
            random.randint(0, 255),
            random.randint(0, 255),
        ),
        x=random.randint(0, 300),
        y = random.randint(0, 400),
    )
    rects.append(rect)

g = game.Game(
    objects=rects,
)
g.run()
