import pygame

class GameContext :
    def __init__(
        self,
        dt, events, keys,
        game,
    ):
        self.dt = dt
        self.events = events
        self.keys = keys
        self.game = game
        # ctx.screen -> ctx.game.screen

class Game:
    def __init__(
        self,
        resolution=(640, 480),
        bg_color=(0, 0, 0),
        fps=30,
        objects=[],
    ):
        self.resolution = resolution
        self.bg_color = bg_color
        self.fps = fps
        self.objects = objects
    def run(self):
        self.screen = pygame.display.set_mode(self.resolution)
        clock = pygame.time.Clock()
        running = True
        while running :
            # Здесь код на каждый кадр

            dt = clock.tick(self.fps) / 1000.0
            events = pygame.event.get()
            for event in events :
                if event.type == pygame.QUIT :
                    running = False

            self.screen.fill(self.bg_color)
            
            keys = pygame.key.get_pressed()
            ctx = GameContext(dt, events, keys, self)
            
            for o in self.objects :
                o.update(ctx)
                o.draw(ctx)

            # Вывести всё нарисованное на окно
            pygame.display.update()
        pygame.quit()

class GameObject:
    def update(self):
        pass
    def draw(self):
        pass
# Rectangle - прямоугольник
class Rect(GameObject):
    def __init__(
        self,
        x = 0, y = 0,
        w = 100, h = 100,
        fill_color=(255, 255, 255)
    ):
        self.x = x
        self.y = y
        self.w = w
        self.h = h
        self.fill_color = fill_color

    def draw(self, ctx):
        pygame.draw.rect(
            ctx.game.screen, self.fill_color,
            (self.x, self.y,
             self.w, self.h),
        )


