import pygame

class GameContext :
    def __init__(
        self,
        dt, events, keys,
        game,
    ):
        self.dt = dt
        self.events = events
        self.keys = keys
        self.game = game
        # ctx.screen -> ctx.game.screen

class Game:
    def __init__(
        self,
        resolution=(640, 480),
        bg_color=(0, 0, 0),
        fps=30,
        objects=[],
    ):
        self.resolution = resolution
        self.bg_color = bg_color
        self.fps = fps
        self.objects = objects
    def run(self):
        self.screen = pygame.display.set_mode(self.resolution)
        clock = pygame.time.Clock()
        running = True
        while running : # gist.surdeus.su/surdeus
            # Здесь код на каждый кадр

            dt = clock.tick(self.fps) / 1000.0
            events = pygame.event.get()
            for event in events :
                if event.type == pygame.QUIT :
                    running = False

            self.screen.fill(self.bg_color)
            
            keys = pygame.key.get_pressed()
            ctx = GameContext(dt, events, keys, self)
            
            for o in self.objects :
                o.update(ctx)
                o.draw(ctx)

            # Вывести всё нарисованное на окно
            pygame.display.update()
        pygame.quit()

class GameObject:
    def update(self, ctx):
        pass
    def draw(self, ctx):
        pass
# Rectangle - прямоугольник
class Rect(GameObject):
    def __init__(
        self,
        x = 0, y = 0,
        w = 100, h = 100,
        fill_color=(255, 255, 255),
        visible=True,
    ):
        self.x = x
        self.y = y
        self.w = w
        self.h = h
        self.fill_color = fill_color
        self.visible = visible

    def draw(self, ctx):
        if not self.visible :
            return
        pygame.draw.rect(
            ctx.game.screen, self.fill_color,
            (self.x, self.y,
             self.w, self.h),
        )
    # Содержит ли точку.
    def contains_point(self, px, py):
        x, y, w, h = self.x, self.y, self.w, self.h
        return (
            py >= y and py <= (y + h) and
            px >= x and px <= (x + w)
        )
    def points(self):
        x, y, w, h = self.x, self.y, self.w, self.h
        return ((x, y),
                (x + w, y),
                (x + w, y + h),
                (x, y + h))
    def intersects_with(self, other):
        for point in other.points() :
            if self.contains_point(point[0], point[1]) :
                return True
        for point in self.points() :
            if other.contains_point(point[0], point[1]) :
                return True
        return False


