import pygame

screen = pygame.display.set_mode((640, 480))
fps = 30

class GameContext:
    def __init__(self, keys, dt, screen):
        self.dt = dt
        self.keys = keys
        self.screen = screen

class MyCube:
    def __init__(
        self,
        x=0, y=0,
        w=100, h=100,
        fill_color=(255, 255, 255),
        speed=100,
    ) :
        self.x = x
        self.y = y
        self.w = w
        self.h = h
        self.fill_color = fill_color
        self.speed = speed
        self.visible = True
    def update(self, ctx):
        if ctx.keys[pygame.K_a] :
            self.x -= self.speed * ctx.dt
        if ctx.keys[pygame.K_d] :
            self.x += self.speed * ctx.dt
        if ctx.keys[pygame.K_w] :
            self.y -= self.speed * ctx.dt
        if ctx.keys[pygame.K_s] :
            self.y += self.speed * ctx.dt
    def draw(self, ctx):
        if not self.visible :
            return
        pygame.draw.rect(
            ctx.screen, self.fill_color,
            (self.x, self.y, self.w, self.h)
        )
    
clock = pygame.time.Clock()
running = True
import random
cubes = [MyCube(
    speed=random.randint(30, 200),
    fill_color=(random.randint(0, 255), random.randint(0, 255),
                random.randint(0, 255))
) for i in range(1000)]

bg_color=(0, 0, 0)

while running :
    screen.fill(bg_color)
    dt = clock.tick(30) / 1000.0
    keys = pygame.key.get_pressed()
    events = pygame.event.get()
    for event in events :
        if event.type == pygame.QUIT :
            running = False
    ctx = GameContext(keys, dt, screen)
    #cube1.update(ctx)
    #cube1.draw(ctx)
    #cube2.update(ctx)
    #cube2.draw(ctx)
    for cube in cubes :
        cube.update(ctx)
        cube.draw(ctx)
    pygame.display.update()
pygame.quit()

